# إعداد MongoDB للموقع

## المتطلبات
- Node.js (الإصدار 14 أو أحدث)
- MongoDB (محلي أو MongoDB Atlas)

## خطوات التثبيت

### 1. تثبيت المكتبات المطلوبة
```bash
npm install
```

### 2. إعداد MongoDB

#### خيار 1: MongoDB محلي
1. قم بتثبيت MongoDB على جهازك
2. شغّل MongoDB
3. في ملف `.env` استخدم:
```
MONGODB_URI=mongodb://localhost:27017/jumhour
```

#### خيار 2: MongoDB Atlas (السحابة)
1. أنشئ حساب على [MongoDB Atlas](https://www.mongodb.com/cloud/atlas)
2. أنشئ cluster جديد
3. احصل على Connection String
4. في ملف `.env` استخدم:
```
MONGODB_URI=mongodb+srv://username:password@cluster.mongodb.net/jumhour
```

### 3. إنشاء ملف `.env`
انسخ ملف `.env.example` إلى `.env` وعدّل الإعدادات:
```bash
cp .env.example .env
```

### 4. تشغيل السيرفر
```bash
npm start
```

أو للتطوير مع إعادة التشغيل التلقائي:
```bash
npm run dev
```

السيرفر سيعمل على: `http://localhost:3000`

## API Endpoints

### المنتجات
- `GET /api/products` - جلب جميع المنتجات
- `GET /api/products?category=volcanic` - جلب منتجات حسب الفئة
- `GET /api/products/:id` - جلب منتج محدد
- `POST /api/products` - إضافة منتج جديد
- `PUT /api/products/:id` - تحديث منتج
- `DELETE /api/products/:id` - حذف منتج

### Health Check
- `GET /api/health` - فحص حالة السيرفر وقاعدة البيانات

## المميزات
✅ حفظ البيانات في MongoDB بدلاً من localStorage
✅ API RESTful كامل
✅ دعم CORS للاتصال من أي مصدر
✅ التحقق من البيانات (Validation)
✅ معالجة الأخطاء

## ملاحظات
- البيانات الآن محفوظة في قاعدة بيانات حقيقية
- يمكن الوصول للبيانات من أي مكان
- البيانات آمنة ومستمرة
- يمكن إضافة المزيد من المميزات بسهولة

