// Login functionality
const API_BASE_URL = window.location.origin;

document.addEventListener('DOMContentLoaded', () => {
    const loginForm = document.getElementById('loginForm');
    const formMessage = document.getElementById('formMessage');
    const loginBtn = document.getElementById('loginBtn');

    // Check if already logged in
    checkAuthStatus();

    loginForm.addEventListener('submit', async (e) => {
        e.preventDefault();
        
        const username = document.getElementById('username').value.trim();
        const password = document.getElementById('password').value;

        if (!username || !password) {
            showMessage('يرجى إدخال اسم المستخدم وكلمة المرور', 'error');
            return;
        }

        // Disable button and show loading
        loginBtn.disabled = true;
        loginBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> جاري تسجيل الدخول...';

        try {
            const response = await fetch(`${API_BASE_URL}/api/auth/login`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                credentials: 'include', // Important for sessions
                body: JSON.stringify({ username, password }),
            });

            const data = await response.json();

            if (response.ok) {
                showMessage('تم تسجيل الدخول بنجاح! جاري التوجيه...', 'success');
                setTimeout(() => {
                    window.location.href = '/admin';
                }, 1000);
            } else {
                showMessage(data.error || 'اسم المستخدم أو كلمة المرور غير صحيحة', 'error');
                loginBtn.disabled = false;
                loginBtn.innerHTML = '<i class="fas fa-sign-in-alt"></i> تسجيل الدخول';
            }
        } catch (error) {
            console.error('Login error:', error);
            showMessage('حدث خطأ أثناء تسجيل الدخول. يرجى المحاولة مرة أخرى.', 'error');
            loginBtn.disabled = false;
            loginBtn.innerHTML = '<i class="fas fa-sign-in-alt"></i> تسجيل الدخول';
        }
    });
});

async function checkAuthStatus() {
    try {
        const response = await fetch(`${API_BASE_URL}/api/auth/status`, {
            credentials: 'include'
        });
        const data = await response.json();
        
        if (data.isAuthenticated) {
            window.location.href = '/admin';
        }
    } catch (error) {
        console.error('Auth check error:', error);
    }
}

function showMessage(message, type) {
    const formMessage = document.getElementById('formMessage');
    formMessage.textContent = message;
    formMessage.className = `form-message show ${type}`;
    
    setTimeout(() => {
        formMessage.classList.remove('show');
    }, 5000);
}

