// Report Details Page Logic
const API_BASE_URL = window.location.origin;

// Reports data (same as reports.js)
const reports = [
    {
        id: 1,
        title: "مصمت عادي 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-12-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-12-copy-724x1024.jpg"
    },
    {
        id: 2,
        title: "بخاري مباني 3 فتحات مقاس 10",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-10-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-10-copy-724x1024.jpg"
    },
    {
        id: 3,
        title: "مباني 3 فتحات مقاس 10",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-6-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-6-copy-724x1024.jpg"
    },
    {
        id: 4,
        title: "تمديدات 6 فتحات مقاس 15",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-copy-724x1024.jpg"
    },
    {
        id: 5,
        title: "بخاري 3 فتحات مقاس 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-9-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-9-copy-724x1024.jpg"
    },
    {
        id: 6,
        title: "مباني 3 فتحات مقاس 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-5-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-5-copy-724x1024.jpg"
    },
    {
        id: 7,
        title: "تمديدات 6 فتحات مقاس 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-2-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-2-copy-724x1024.jpg"
    },
    {
        id: 8,
        title: "تمديدات 8 فتحات مقاس 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-7-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-7-copy-724x1024.jpg"
    },
    {
        id: 9,
        title: "معزول جفالي أصلي 25",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-4-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-4-copy-724x1024.jpg"
    },
    {
        id: 10,
        title: "معزول جفالي أصلي 30",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-3-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-3-copy-724x1024.jpg"
    },
    {
        id: 11,
        title: "معزول أزرق ساندويش 30",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-8-copy-724x1024.jpg",
        pdfLink: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-8-copy-724x1024.jpg"
    }
];

function getReportById(id) {
    return reports.find(report => report.id === parseInt(id));
}

function displayReportDetails(report) {
    const wrapper = document.getElementById('reportDetailsWrapper');
    const page = document.querySelector('.report-details-page');
    if (!wrapper) return;

    document.title = `تقرير اختبار: ${report.title}`;

    // Set background image with blur
    if (page && report.image) {
        page.style.setProperty('--report-bg-image', `url('${report.image}')`);
        page.setAttribute('data-bg-image', 'true');
    }

    wrapper.innerHTML = `
        <a href="reports.html" class="back-button">
            <i class="fas fa-arrow-right"></i> العودة إلى التقارير
        </a>
        <h1 class="report-details-title">تقرير اختبار</h1>
        <h2 class="report-details-subtitle">${report.title}</h2>
        <p class="report-details-english">Hollow Block</p>
        <div class="report-details-card">
            <h2 class="report-card-title">تقرير اختبار</h2>
            <div class="report-card-bar">
                <p class="report-card-bar-text">Hollow Block</p>
            </div>
            <h3 class="report-card-subtitle">${report.title}</h3>
            <div class="report-details-image">
                <img src="${report.image}" alt="${report.title}" onerror="this.parentElement.style.display='none'">
            </div>
            <a href="${report.pdfLink}" target="_blank" class="btn-download-report" download>
                <i class="fas fa-download"></i>
                اضغط هنا لتحميل الملف الأصلي
            </a>
        </div>
    `;
}

document.addEventListener('DOMContentLoaded', () => {
    const urlParams = new URLSearchParams(window.location.search);
    const reportId = urlParams.get('id');

    const wrapper = document.getElementById('reportDetailsWrapper');

    if (!reportId) {
        if (wrapper) {
            wrapper.innerHTML = `
                <div class="error-state">
                    <i class="fas fa-exclamation-circle"></i>
                    <p>لم يتم تحديد معرف التقرير.</p>
                    <a href="reports.html" style="margin-top: 20px; padding: 10px 20px; background: #ffd700; color: #1a5f7a; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; display: inline-block;">
                        العودة إلى التقارير
                    </a>
                </div>
            `;
        }
        return;
    }

    const report = getReportById(reportId);
    
    if (!report) {
        if (wrapper) {
            wrapper.innerHTML = `
                <div class="error-state">
                    <i class="fas fa-exclamation-circle"></i>
                    <p>التقرير المطلوب غير موجود.</p>
                    <a href="reports.html" style="margin-top: 20px; padding: 10px 20px; background: #ffd700; color: #1a5f7a; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; display: inline-block;">
                        العودة إلى التقارير
                    </a>
                </div>
            `;
        }
        return;
    }

    displayReportDetails(report);
});

