// Reports Page Logic
const API_BASE_URL = window.location.origin;

// Reports data from the old website
const reports = [
    {
        id: 1,
        title: "مصمت عادي 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-12-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d9%85%d8%b5%d9%85%d8%aa-%d8%b9%d8%a7%d8%af%d9%8a-20/"
    },
    {
        id: 2,
        title: "بخاري مباني 3 فتحات مقاس 10",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-10-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a8%d8%ae%d8%a7%d8%b1%d9%8a-%d9%85%d8%a8%d8%a7%d9%86%d9%8a-3-%d9%81%d8%aa%d8%ad%d8%a7%d8%aa-%d9%85%d9%82%d8%a7%d8%b3-10/"
    },
    {
        id: 3,
        title: "مباني 3 فتحات مقاس 10",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-6-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d9%85%d8%a8%d8%a7%d9%86%d9%8a-3-%d9%81%d8%aa%d8%ad%d8%a7%d8%aa-%d9%85%d9%82%d8%a7%d8%b3-10/"
    },
    {
        id: 4,
        title: "تمديدات 6 فتحات مقاس 15",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d8%aa%d9%85%d8%af%d9%8a%d8%af%d8%a7%d8%aa-6-%d9%81%d8%aa%d8%ad%d8%a7%d8%aa-%d9%85%d9%82%d8%a7%d8%b3-15/"
    },
    {
        id: 5,
        title: "بخاري 3 فتحات مقاس 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-9-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d8%a8%d8%ae%d8%a7%d8%b1%d9%8a-3-%d9%81%d8%aa%d8%ad%d8%a7%d8%aa-%d9%85%d9%82%d8%a7%d8%b3-20/"
    },
    {
        id: 6,
        title: "مباني 3 فتحات مقاس 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-5-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d9%85%d8%a8%d8%a7%d9%86%d9%8a-3-%d9%81%d8%aa%d8%ad%d8%a7%d8%aa-%d9%85%d9%82%d8%a7%d8%b3-20/"
    },
    {
        id: 7,
        title: "تمديدات 6 فتحات مقاس 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-2-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d8%aa%d9%85%d8%af%d9%8a%d8%af%d8%a7%d8%aa-6-%d9%81%d8%aa%d8%ad%d8%a7%d8%aa-%d9%85%d9%82%d8%a7%d8%b3-20/"
    },
    {
        id: 8,
        title: "تمديدات 8 فتحات مقاس 20",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-7-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d8%aa%d9%85%d8%af%d9%8a%d8%af%d8%a7%d8%aa-8-%d9%81%d8%aa%d8%ad%d8%a7%d8%aa-%d9%85%d9%82%d8%a7%d8%b3-20/"
    },
    {
        id: 9,
        title: "معزول جفالي أصلي 25",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-4-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d9%85%d8%b9%d8%b2%d9%88%d9%84-%d8%ac%d9%81%d8%a7%d9%84%d9%8a-%d8%a3%d8%b5%d9%84%d9%8a-25/"
    },
    {
        id: 10,
        title: "معزول جفالي أصلي 30",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-3-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d9%85%d8%b9%d8%b2%d9%88%d9%84-%d8%ac%d9%81%d8%a7%d9%84%d9%8a-%d8%a3%d8%b5%d9%84%d9%8a-30/"
    },
    {
        id: 11,
        title: "معزول أزرق ساندويش 30",
        date: "يونيو 19, 2024",
        image: "https://gaamor.com/wp-content/uploads/2024/06/تقرير-اختبار-Hollow-Block-8-copy-724x1024.jpg",
        link: "https://gaamor.com/%d8%aa%d9%82%d8%b1%d9%8a%d8%b1-%d8%a7%d8%ae%d8%aa%d8%a8%d8%a7%d8%b1-%d9%85%d8%b9%d8%b2%d9%88%d9%84-%d8%a3%d8%b2%d8%b1%d9%82-%d8%b3%d8%a7%d9%86%d8%af%d9%88%d9%8a%d8%b4-30/"
    }
];

function createReportCard(report) {
    const card = document.createElement('div');
    card.className = 'report-card';
    
    card.innerHTML = `
        <div class="report-image">
            <img src="${report.image}" alt="${report.title}" onerror="this.src='img/placeholder.png'">
        </div>
        <div class="report-content">
            <h3 class="report-title">${report.title}</h3>
            <div class="report-date">
                <i class="far fa-calendar"></i>
                <span>${report.date}</span>
            </div>
            <a href="report-details.html?id=${report.id}" class="report-link">
                للمزيد
                <i class="fas fa-arrow-left"></i>
            </a>
        </div>
    `;
    
    return card;
}

function displayReports() {
    const reportsGrid = document.getElementById('reportsGrid');
    if (!reportsGrid) return;
    
    reportsGrid.innerHTML = '';
    
    reports.forEach(report => {
        const card = createReportCard(report);
        reportsGrid.appendChild(card);
    });
}

document.addEventListener('DOMContentLoaded', () => {
    displayReports();
});

