# نظام تسجيل الدخول - لوحة التحكم

## كيفية الوصول للوحة التحكم

### الرابط:
```
http://your-domain.com/admin
```

أو محلياً:
```
http://localhost:3000/admin
```

## بيانات الدخول الافتراضية

عند أول تشغيل للسيرفر، سيتم إنشاء حساب أدمن افتراضي:

**اسم المستخدم:** `admin`  
**كلمة المرور:** `admin123`

⚠️ **مهم جداً:** غيّر كلمة المرور الافتراضية فوراً!

## تغيير بيانات الدخول

يمكنك تغيير بيانات الدخول من ملف `.env`:

```env
ADMIN_USERNAME=your-username
ADMIN_PASSWORD=your-secure-password
```

ثم أعد تشغيل السيرفر.

## المميزات

✅ نظام تسجيل دخول آمن  
✅ جلسات محمية (Sessions)  
✅ تشفير كلمات المرور (bcrypt)  
✅ حماية جميع عمليات CRUD  
✅ تسجيل خروج آمن  

## ملاحظات أمنية

1. **غيّر SESSION_SECRET** في ملف `.env`:
   ```
   SESSION_SECRET=your-random-secret-key-here
   ```

2. **استخدم كلمة مرور قوية** للأدمن

3. **في الإنتاج**، استخدم HTTPS وعدّل:
   ```javascript
   cookie: {
       secure: true, // Only over HTTPS
       ...
   }
   ```

## API Endpoints

- `POST /api/auth/login` - تسجيل الدخول
- `POST /api/auth/logout` - تسجيل الخروج
- `GET /api/auth/status` - فحص حالة الجلسة
- `POST /api/auth/change-password` - تغيير كلمة المرور (محمي)

