# Script to kill process on port 3000
$port = 3000
Write-Host "Searching for processes on port $port..." -ForegroundColor Yellow

$connections = netstat -ano | findstr ":$port"
if ($connections) {
    $pids = $connections | ForEach-Object {
        if ($_ -match '\s+(\d+)\s*$') {
            $matches[1]
        }
    } | Select-Object -Unique
    
    foreach ($pid in $pids) {
        Write-Host "Killing process $pid..." -ForegroundColor Red
        taskkill /PID $pid /F
    }
    Write-Host "✅ All processes on port $port have been stopped" -ForegroundColor Green
} else {
    Write-Host "No processes found on port $port" -ForegroundColor Green
}

