# حل مشاكل التعديلات لا تظهر

## المشكلة: التعديلات لا تظهر في الموقع

### الحلول:

#### 1. إعادة تشغيل السيرفر
```bash
# أوقف السيرفر (Ctrl+C)
# ثم شغله مرة أخرى
npm run dev
```

#### 2. تنظيف Cache المتصفح
- **Chrome/Edge:** اضغط `Ctrl + Shift + Delete` → اختر "Cached images and files" → Clear
- **أو:** اضغط `Ctrl + F5` لإعادة تحميل الصفحة بدون cache
- **أو:** افتح Developer Tools (F12) → اضغط بزر الماوس الأيمن على زر Refresh → اختر "Empty Cache and Hard Reload"

#### 3. التحقق من الملفات
تأكد أنك تعدل الملفات في:
- ✅ `public/index.html` (وليس `index.html` في الجذر)
- ✅ `public/css/styles.css` (وليس `styles.css` في الجذر)
- ✅ `public/js/script.js` (وليس `script.js` في الجذر)

#### 4. التحقق من المسارات
تأكد أن المسارات في HTML صحيحة:
```html
<!-- صحيح -->
<link rel="stylesheet" href="css/styles.css">
<script src="js/script.js"></script>

<!-- خطأ -->
<link rel="stylesheet" href="styles.css">
<script src="script.js"></script>
```

#### 5. فتح Developer Console
اضغط `F12` وتحقق من:
- **Console Tab:** هل هناك أخطاء؟
- **Network Tab:** هل الملفات تُحمّل بنجاح (Status 200)؟

#### 6. التحقق من السيرفر
```bash
# تأكد أن السيرفر يعمل
curl http://localhost:3000

# أو افتح في المتصفح
http://localhost:3000
```

## نصائح:

1. **استخدم `npm run dev`** - يعيد التشغيل تلقائياً عند التعديل
2. **استخدم Hard Refresh:** `Ctrl + F5`
3. **افتح Developer Tools:** `F12` لرؤية الأخطاء
4. **تحقق من Console:** قد تكون هناك أخطاء JavaScript

## إذا لم يعمل:

1. أوقف السيرفر تماماً
2. احذف `node_modules` و `package-lock.json`
3. شغّل `npm install`
4. شغّل `npm run dev` مرة أخرى

